unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, PlayFld;

type
  GameState = (
      gsBrandNew,
      gsInProgress,
      gsPaused,
      gsOver
      );

  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    CtrlPanel: System.Windows.Forms.Panel;

    label3: System.Windows.Forms.Label;
    label4: System.Windows.Forms.Label;
    label5: System.Windows.Forms.Label;
    label6: System.Windows.Forms.Label;
    label7: System.Windows.Forms.Label;

    ScoreBar: System.Windows.Forms.StatusBar;
    MainMenu1: System.Windows.Forms.MainMenu;
    MenuItem1: System.Windows.Forms.MenuItem;
    MenuItem2: System.Windows.Forms.MenuItem;

    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure MenuItem2_Click(sender: System.Object; e: System.EventArgs);
    procedure MenuItem1_Click(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
  {$ENDREGION}
  strict protected
    theGame: GameState;
    CurrentScore: Integer;
    f: TPlayingField;

    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;

    procedure AddScore(score: Integer);
    procedure GameOver;
    procedure NewGame;
  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.CtrlPanel := System.Windows.Forms.Panel.Create;
  Self.label7 := System.Windows.Forms.Label.Create;
  Self.label6 := System.Windows.Forms.Label.Create;
  Self.label5 := System.Windows.Forms.Label.Create;
  Self.label4 := System.Windows.Forms.Label.Create;
  Self.label3 := System.Windows.Forms.Label.Create;
  Self.ScoreBar := System.Windows.Forms.StatusBar.Create;
  Self.MainMenu1 := System.Windows.Forms.MainMenu.Create;
  Self.MenuItem1 := System.Windows.Forms.MenuItem.Create;
  Self.MenuItem2 := System.Windows.Forms.MenuItem.Create;
  Self.CtrlPanel.SuspendLayout;
  Self.SuspendLayout;
  //
  // CtrlPanel
  //
  Self.CtrlPanel.BorderStyle := System.Windows.Forms.BorderStyle.Fixed3D;
  Self.CtrlPanel.Controls.Add(Self.label7);
  Self.CtrlPanel.Controls.Add(Self.label6);
  Self.CtrlPanel.Controls.Add(Self.label5);
  Self.CtrlPanel.Controls.Add(Self.label4);
  Self.CtrlPanel.Controls.Add(Self.label3);
  Self.CtrlPanel.Location := System.Drawing.Point.Create(0, 0);
  Self.CtrlPanel.Name := 'CtrlPanel';
  Self.CtrlPanel.Size := System.Drawing.Size.Create(176, 240);
  Self.CtrlPanel.TabIndex := 0;
  //
  // label7
  //
  Self.label7.AutoSize := True;
  Self.label7.Location := System.Drawing.Point.Create(16, 204);
  Self.label7.Name := 'label7';
  Self.label7.Size := System.Drawing.Size.Create(69, 16);
  Self.label7.TabIndex := 7;
  Self.label7.Text := 'Space - drop';
  //
  // label6
  //
  Self.label6.AutoSize := True;
  Self.label6.Location := System.Drawing.Point.Create(16, 188);
  Self.label6.Name := 'label6';
  Self.label6.Size := System.Drawing.Size.Create(87, 16);
  Self.label6.TabIndex := 6;
  Self.label6.Text := 'UpArrow - rotate';
  //
  // label5
  //
  Self.label5.AutoSize := True;
  Self.label5.Location := System.Drawing.Point.Create(16, 172);
  Self.label5.Name := 'label5';
  Self.label5.Size := System.Drawing.Size.Create(123, 16);
  Self.label5.TabIndex := 5;
  Self.label5.Text := 'RightArrow - move right';
  //
  // label4
  //
  Self.label4.AutoSize := True;
  Self.label4.Location := System.Drawing.Point.Create(16, 156);
  Self.label4.Name := 'label4';
  Self.label4.Size := System.Drawing.Size.Create(108, 16);
  Self.label4.TabIndex := 4;
  Self.label4.Text := 'LeftArrow - move left';
  //
  // label3
  //
  Self.label3.AutoSize := True;
  Self.label3.Location := System.Drawing.Point.Create(8, 136);
  Self.label3.Name := 'label3';
  Self.label3.Size := System.Drawing.Size.Create(72, 16);
  Self.label3.TabIndex := 3;
  Self.label3.Text := 'Control Keys:';
  //
  // ScoreBar
  //
  Self.ScoreBar.Location := System.Drawing.Point.Create(0, 244);
  Self.ScoreBar.Name := 'ScoreBar';
  Self.ScoreBar.Size := System.Drawing.Size.Create(408, 22);
  Self.ScoreBar.TabIndex := 1;
  Self.ScoreBar.Text := 'Score: 0';
  //
  // MainMenu1
  //
  Self.MainMenu1.MenuItems.AddRange([Self.MenuItem1, Self.MenuItem2]);
  //
  // MenuItem1
  //
  Self.MenuItem1.Index := 0;
  Self.MenuItem1.Text := '&Click Here To Start';
  Include(Self.MenuItem1.Click, Self.MenuItem1_Click);
  //
  // MenuItem2
  //
  Self.MenuItem2.Index := 1;
  Self.MenuItem2.Text := 'Click Here to &Quit';
  Include(Self.MenuItem2.Click, Self.MenuItem2_Click);
  //
  // TWinForm
  //
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(408, 266);
  Self.Controls.Add(Self.ScoreBar);
  Self.Controls.Add(Self.CtrlPanel);
  Self.Menu := Self.MainMenu1;
  Self.Name := 'TWinForm';
  Self.Text := 'NETrix';
  Include(Self.KeyDown, Self.TWinForm_KeyDown);
  Self.CtrlPanel.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.TWinForm_KeyDown(sender: System.Object; e: System.Windows.Forms.KeyEventArgs);
begin
  if Assigned(f) then
    case (e.KeyCode) of
      Keys.Left:  f.GoLeft();
      Keys.Right: f.GoRight();
      Keys.Up:    f.TurnClockwise();
      Keys.Down:  f.GoDown();
      Keys.Clear: f.TurnCounterclockwise();
      Keys.Space: f.Drop();
    end; { case }
end;

procedure TWinForm.MenuItem1_Click(sender: System.Object; e: System.EventArgs);
begin
  case theGame of
    GameState.gsInProgress:
      begin
        f.PauseGame();
        MenuItem1.Text := 'Click to Resume';
        theGame := GameState.gsPaused;
      end;
    GameState.gsPaused:
      begin
        f.ResumeGame();
        MenuItem1.Text := 'Click to Pause';
        theGame := GameState.gsInProgress;
      end;
    else begin
        MenuItem1.Text := 'Click to Pause';
        theGame := GameState.gsInProgress;
        NewGame();
      end;
  end;
end;

procedure TWinForm.MenuItem2_Click(sender: System.Object; e: System.EventArgs);
begin
  Close
end;

procedure TWinForm.GameOver;
begin
  MenuItem1.Text := 'Click for a new Game';
  theGame := GameState.gsOver;
end;

procedure TWinForm.AddScore(score: Integer);
begin
  CurrentScore := CurrentScore + score;
  ScoreBar.Text := 'Score: '+CurrentScore.ToString;
end;

procedure TWinForm.NewGame;
begin
  ScoreBar.Text := 'Score: 0';
  if NOT Assigned(f) then
    f := TPlayingField.Create(Self,
                       ClientSize.Width div 2,
                       0,
                       ClientSize.Width div 2,
                       ClientSize.Height - ScoreBar.Height - 1);
  f.NewGame();
end;

end.
